﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using System.Text;
using VRM.Integration.Servicebus.Core;

namespace VRM.Integration.FTP.MVI.Messages
{
    [Export(typeof (IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.FTPCorrespondingIdsResponse)]
    [DataContract]
    public class FTPCorrespondingIdsResponse : MessageBase
    {
        [DataMember]
        public CorrespondingIDs[] CorrespondingIdList { get; set; }

        [DataMember]
        public bool ExceptionOccured { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public string RawMviExceptionMessage { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string Url { get; set; }

        [DataMember]
        public MessageProcessType FetchMessageProcessType { get; set; }

        private byte[] _ssnBytes;
        
        [DataMember]
        public string SocialSecurityNumber
        {
            get { return _ssnBytes == null ? "" : Encoding.UTF8.GetString(_ssnBytes); }
            set
            {
                if (value == null)
                    _ssnBytes = null;
                else
                    _ssnBytes = Encoding.UTF8.GetBytes(value);
            }
        }

        [DataMember]
        public string Edipi { get; set; }

        [DataMember]
        public string ParticipantId { get; set; }

        [DataMember]
        public string FirstName { get; set; }

        [DataMember]
        public string MiddleName { get; set; }

        [DataMember]
        public string FamilyName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public string FullAddress { get; set; }

        [DataMember]
        public string FullName { get; set; }

        [DataMember]
        public string DateofBirth { get; set; }
    }

}
